document.addEventListener('DOMContentLoaded', function () {
    const badge = document.getElementById('badge');
    const placeholder = document.querySelector('.upload-placeholder');
    const resetButton = document.querySelector('button[onclick="resetBadge()"]');
    
    // Ensure badge is hidden on page load
    if (badge) {
        badge.style.display = 'none';
    }
    
    // Initially hide the reset button
    resetButton.style.display = 'none';
    
    // Add event listeners for sliders after page load
    const horizontalSlider = document.getElementById('horizontal');
    const verticalSlider = document.getElementById('vertical');
    const zoomSlider = document.getElementById('zoom');
    const image = document.getElementById('profileImage');
    
    // Update image transform based on slider values
    horizontalSlider.addEventListener('input', function () {
        updateImageTransform();
    });
    verticalSlider.addEventListener('input', function () {
        updateImageTransform();
    });
    zoomSlider.addEventListener('input', function () {
        updateImageTransform();
    });
    
    function updateImageTransform() {
        // Get slider values
        const horizontal = horizontalSlider.value;
        const vertical = verticalSlider.value;
        const zoom = zoomSlider.value;

        // Update the image transform based on the slider values
        image.style.transform = `translate(${horizontal}px, ${vertical}px) scale(${zoom})`;

        // If in circle shape, apply the same transform to the badge's background
        if (document.getElementById('circle').checked) {
            badge.style.backgroundSize = `${zoom * 100}%`;  // Scale background image
            badge.style.backgroundPosition = `${horizontal}px ${vertical}px`; // Position background image
        }
    }
});

// Function to handle previewing and displaying the uploaded image
function previewImage(event) {
    const image = document.getElementById('profileImage');
    const placeholder = document.querySelector('.upload-placeholder');
    const badge = document.getElementById('badge');
    const downloadButton = document.getElementById('downloadButton');
    const resetButton = document.querySelector('button[onclick="resetBadge()"]');
    const changeImageButton = document.getElementById('changeImageButton');
    const imageUpload = document.getElementById('imageUpload');

    // Set the image source from the uploaded file
    const uploadedImage = URL.createObjectURL(event.target.files[0]);
    image.src = uploadedImage;

    // Hide the placeholder and show the badge container
    placeholder.style.display = "none"; 
    badge.style.display = "flex";

    // Show the download and reset buttons
    downloadButton.style.display = "block";
    resetButton.style.display = 'block';
    changeImageButton.style.display = 'block';  // Show the change image button after upload

    // Check the shape, and apply the image accordingly
    if (document.getElementById('circle').checked) {
        // Apply image as background when circle is selected
        badge.style.backgroundImage = `url(${uploadedImage})`;
        document.getElementById('profileImageContainer').style.display = 'none'; // Hide the image element in circle
    } else {
        // Revert to using the image as the src for the <img> element in square shape
        badge.style.backgroundImage = ''; // Remove the background image
        document.getElementById('profileImageContainer').style.display = 'flex'; // Show the image element in square
    }
}

// Function to change the shape of the badge container based on the selected shape
function changeShape(shape) {
    const badge = document.getElementById('badge');
    const profileImageContainer = document.getElementById('profileImageContainer');
    const image = document.getElementById('profileImage');
    
    if (shape === 'circle') {
        badge.classList.add('circle'); // Make badge container circular
        badge.style.backgroundImage = `url(${image.src})`; // Set the image as background
        profileImageContainer.style.display = 'none'; // Hide image element in the circle shape
    } else {
        badge.classList.remove('circle'); // Revert to default square shape
        badge.style.backgroundImage = ''; // Remove background image
        profileImageContainer.style.display = 'flex'; // Show image element in square shape
    }

    // Show reset button when the shape is changed
    const resetButton = document.querySelector('button[onclick="resetBadge()"]');
    resetButton.style.display = 'block';
}

// Function to reset only the image controls (position, zoom, and shape)
function resetBadge() {
    const image = document.getElementById('profileImage');
    const resetButton = document.querySelector('button[onclick="resetBadge()"]');

    // Reset slider values
    document.getElementById('horizontal').value = 0;
    document.getElementById('vertical').value = 0;
    document.getElementById('zoom').value = 1;

    // Reset shape selection
    document.getElementById('square').checked = true;
    changeShape('square');

    // Reset the image transform to the default position and zoom
    image.style.transform = "translate(0px, 0px) scale(1)";

    // Reset background image position and size for circle
    badge.style.backgroundPosition = 'center';
    badge.style.backgroundSize = '100%';

    // Hide the reset button after resetting
    resetButton.style.display = 'none';
    
    // Reset the file input field to allow new image upload
    const fileInput = document.getElementById('imageUpload');
    fileInput.value = ''; // Clear the input value
}

function generateImageWithWave() {
    // Select the element where the wave background needs to be added
    const badge = document.querySelector('.badge-container.circle');
    
    // Create the wave background element and style it
    const waveBackground = document.createElement('div');
    waveBackground.style.position = 'absolute';
    waveBackground.style.bottom = '0';
    waveBackground.style.width = '100%';
    waveBackground.style.height = '243px';
    waveBackground.style.background = 'url(/images/wave2-GBS.svg) no-repeat center center';
    waveBackground.style.backgroundSize = 'cover';

    // Append the wave background to the badge container
    badge.appendChild(waveBackground);

    // Generate image with dom-to-image and then remove the wave background
    domtoimage.toBlob(badge, { bgcolor: null })
        .then((blob) => {
            const a = document.createElement("a");
            const url = URL.createObjectURL(blob);
            a.download = "TOKEN2049 Singapore 2024.png";
            a.href = url;
            a.click();
            URL.revokeObjectURL(url);

            // Remove the temporary wave background after download
            badge.removeChild(waveBackground);
        })
        .catch(error => {
            console.error('Error downloading image:', error);
            // Clean up if there was an error
            badge.removeChild(waveBackground);
        });
}

// Use this function as the main download trigger
function downloadImage() {
    const badge = document.querySelector('.badge-container');
    if (document.getElementById('circle').checked) {
        // Add the wave and generate image if the circle shape is selected
        generateImageWithWave();
    } else {
        // Use normal image generation without the wave for square shapes
        domtoimage.toBlob(badge, { bgcolor: null })
            .then((blob) => {
                const a = document.createElement("a");
                const url = URL.createObjectURL(blob);
                a.download = "TOKEN2049 Singapore 2024.png";
                a.href = url;
                a.click();
                URL.revokeObjectURL(url);
            })
            .catch(error => {
                console.error('Error downloading image:', error);
            });
    }

    // Show modal or blurred overlay after 1 second
    setTimeout(() => {
        document.getElementById("blurdivid").style.display = "block";
    }, 1000);
}

// Function to close the modal
function closeModal() {
    document.getElementById("blurdivid").style.display = "none";
}
