<?php
// Include the header
include 'includes/header.php';
?>
<div class="container py-5">
    <div class="row image-upload">
        <!-- Control Panel (Left Column 30%) -->
        <div class="col-md-4 left-design">
            <h3 class="upload_heading">I'm Attending Global Blockchain Show</h3>
            <p class="image-body-text">Global AI Show Ddubai is just around the corner, 12 - 13 December 2024. Tell the world you'll be there with a custom badge!</p>
            
            <form action="upload.php" method="POST" enctype="multipart/form-data">
            <div>
                <label class="form-label">Image Shape</label>
                <div class="d-flex align-items-center">
                    <input type="radio" id="square" name="shape" value="square" checked onchange="changeShape('square')">
                    <label for="square">Rectangle</label>
                    <input type="radio" id="circle" name="shape" value="circle" onchange="changeShape('circle')">
                    <label for="circle">Circle</label>

                    <!-- Reset Button with Rotate Icon -->
                    <button class="btn btn-link reset-btn ms-2" type="button" onclick="resetBadge()" style="display: none;">
                        <i class="fa-solid fa-rotate-right reseticon"></i><span class="reset">reset</span>
                    </button>
                </div>
            </div>

                <div class="slider-container mt-3">
                    <div class="input-range">
                        <label for="horizontal">Move horizontally</label>
                        <input type="range" id="horizontal" min="-200" max="200" value="0">
                    </div>
                    <div class="input-range">
                        <label for="vertical">Move vertically</label>
                        <input type="range" id="vertical" min="-200" max="200" value="0">
                    </div>
                    <div class="input-range">
                        <label for="zoom">Zoom</label>
                        <input type="range" id="zoom" min="0.5" max="3" step="0.1" value="1">
                    </div>
                </div>

                <!-- <button class="btn btn-secondary mt-3" type="button" onclick="resetBadge()">Reset</button> -->
            </form>
            <!-- Download Button (Hidden initially) -->
            <button id="downloadButton" class="btn btn-success mt-3" onclick="downloadImage()" style="display: none;">
    <i class="fa fa-arrow-down"></i> Save
</button>       
            <!-- "Change Image" button moved here -->
            <button id="changeImageButton" class="btn btn-primary mt-3" type="button" onclick="document.getElementById('imageUpload').click()" style="display: none;">Change Image</button>
        </div>

        <!-- Badge Preview (Right Column 70%) -->
        <div class="col-md-8 d-flex flex-column align-items-center justify-content-center rigth-image">
                <!-- <svg class="upload-svg" stroke="currentColor" fill="none" viewBox="0 0 48 48" aria-hidden="true">
                    <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
				</svg> -->
            <div class="upload-placeholder" onclick="document.getElementById('imageUpload').click()">
                Upload image<p class="supported-text">PNG, JPG</p>
            </div>

            <!-- Badge Container (Hidden initially) -->
            <div class="badge-container" id="badge">
                <div id="profileImageContainer" class="profile-image-container">
                    <img id="profileImage" class="profile-image" />
                </div>
                <div class="badge-footer">
                    <p class="text-overlay" id="textOverlay">Meet me at<br>Global AI Show<br> Dubai</p>
                </div>
                <div class="wave-background"></div>
            </div>

             </div>
    </div>
</div>

<form id="imageForm" action="upload.php" method="POST" enctype="multipart/form-data" style="display: none;">
    <input type="file" id="imageUpload" name="image" accept="image/*" onchange="previewImage(event)">
</form>

<?php
// Include the footer
include 'includes/footer.php';
?>
